% Keithley KPCI-3108
% Ananlog Input
ai = analoginput('keithley',0); % create device object
% Define Parameters
Ch=0;
sfreq = 10000;
nPoints = 200;

chan = addchannel(ai,Ch); 
set(chan,'InputRange',[-10 10])
%set sampling rate to 1kHz and collect 1 sec worth of data
set(ai,'SampleRate',sfreq)
set(ai,'SamplesPerTrigger',nPoints) % # of data points

start(ai)   %start the acquisition
y = getdata(ai); %move the data from the engine
Y = fft(y,nPoints);
% The power spectrum, a measurement of the power at various frequencies, is
Pyy = Y.* conj(Y) / (nPoints);
% Graph the first 257 points (the other 255 points are redundant) on 
% a meaningful frequency axis.

f = sfreq*(0:(nPoints/2))/(nPoints);
%plot it
figure(1)
plot(y(1:200),'r'), xlabel('samples'), ylabel('Amp(V)'),title('Input Signal') 
delete(ai)  %clear the memory
clear ai
figure(2)
plot(f,Pyy(1:((nPoints/2)+1))), title('Frequency content of the input signal'),xlabel('frequency (Hz)')

clear all

